<?php

namespace Opencart\Catalog\Model\Extension\SebPaymentGateway\Payment;

use Opencart\System\Engine\Model;

class SebPaymentGateway extends Model {
	const PAYMENT_STATUS_TABLE = 'sebpaymentgateway_payment_status';

	public function getMethods(array $address = []): array {
		$this->load->language('extension/sebpaymentgateway/payment/sebpaymentgateway');

		$total = $this->cart->getTotal();

		if (!empty($this->session->data['vouchers'])) {
			$amounts = array_column($this->session->data['vouchers'], 'amount');
		} else {
			$amounts = [];
		}

		$total = $total + array_sum($amounts);

		if ($this->config->get('payment_sebpaymentgateway_total') > 0 && $this->config->get('payment_sebpaymentgateway_total') > $total) {
			$status = false;
		} elseif (!$this->config->get('config_checkout_payment_address')) {
			$status = true;
		} elseif (!$this->config->get('payment_sebpaymentgateway_geo_zone_id')) {
			$status = true;
		} else {
			$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone_to_geo_zone` WHERE `geo_zone_id` = '" . (int)$this->config->get('payment_sebpaymentgateway_geo_zone_id') . "' AND `country_id` = '" . (int)$address['country_id'] . "' AND (`zone_id` = '" . (int)$address['zone_id'] . "' OR `zone_id` = '0')");

			if ($query->num_rows) {
				$status = true;
			} else {
				$status = false;
			}
		}

		return $this->getMethodData($status);
	}

	private function getMethodData(bool $status = true): array {
		if (!$status) {
			return [];
		}

		$option_data['sebpaymentgateway'] = [
			'code' => 'sebpaymentgateway.sebpaymentgateway',
			'name' => $this->getPaymentTitle(),
		];

		return [
			'code'       => 'sebpaymentgateway',
			'name'       => $this->getPaymentTitle(),
			'option'     => $option_data,
			'sort_order' => $this->config->get('payment_sebpaymentgateway_sort_order')
		];
	}

	public function getPaymentTitle(){
		//if custom checkout title is set for current language use that, if not use default from language file
		return $this->config->get('payment_sebpaymentgateway_title_' . $this->config->get('config_language_id')) ? $this->config->get('payment_sebpaymentgateway_title_' . $this->config->get('config_language_id')) : $this->language->get('text_title');
	}

	public function addOrderPaymentStatus($orderReference, $paymentStatus) {
		$this->db->query("INSERT INTO `" . $this->getPaymentStatusTableName() . "` SET `order_reference` = '" . $this->db->escape($orderReference) . "', `status` = '" . $this->db->escape($paymentStatus) . "'");
	}

	public function getPaymentStatusByReference($orderReference) {
		$query = $this->db->query("SELECT * FROM `" . $this->getPaymentStatusTableName() . "` WHERE `order_reference` = '" . $this->db->escape($orderReference) . "'");

		return $query->row;
	}

	public function getPaymentStatusTableName() {
		return DB_PREFIX . self::PAYMENT_STATUS_TABLE;
	}
}
